/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.readers;

import eu.europa.ec.taxud.cesop.domain.TransactionDateEnum;
import eu.europa.ec.taxud.cesop.domain.XmlReportedTransaction;
import eu.europa.ec.taxud.cesop.domain.XmlTypeAndValue;
import eu.europa.ec.taxud.cesop.readers.CesopParsingException;
import eu.europa.ec.taxud.cesop.readers.CesopXmlReader;
import eu.europa.ec.taxud.cesop.utils.LangUtils;
import eu.europa.ec.taxud.cesop.utils.ValidationConstants;
import eu.europa.ec.taxud.cesop.utils.ValidationErrorUtils;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.xml.stream.XMLStreamException;

public class ReportedTransactionXmlReader {
    private static final String PAYMENT_METHOD_NONE = "None";
    private final CesopXmlReader cesopXmlReader;
    private final List<String> otherPaymentMethods;
    private final List<String> otherPspRoles;

    public ReportedTransactionXmlReader(CesopXmlReader cesopXmlReader, List<String> otherPaymentMethods, List<String> otherPspRoles) {
        this.cesopXmlReader = cesopXmlReader;
        this.otherPaymentMethods = otherPaymentMethods;
        this.otherPspRoles = otherPspRoles;
    }

    private static boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value) || "1".equals(value);
    }

    public XmlReportedTransaction parse() throws XMLStreamException {
        if (!this.cesopXmlReader.positionCursorOnStartElement(ValidationConstants.XML.REPORTED_TRANSACTION_QNAME)) {
            throw new XMLStreamException("Tag " + ValidationConstants.XML.REPORTED_TRANSACTION_QNAME + " not found.");
        }
        XmlReportedTransaction xmlReportedTransaction = new XmlReportedTransaction();
        xmlReportedTransaction.setRefund(this.parseIsRefund());
        xmlReportedTransaction.setTransactionIdentifier(this.parseTransactionIdentifier());
        xmlReportedTransaction.setCorrTransactionIdentifier(this.parseCorrTransactionIdentifier());
        if (xmlReportedTransaction.isRefund()) {
            String corrTransactionId = xmlReportedTransaction.getCorrTransactionIdentifier();
            String transactionId = xmlReportedTransaction.getTransactionIdentifier();
            if (corrTransactionId == null || corrTransactionId.trim().isEmpty()) {
                xmlReportedTransaction.setCorrTransactionIdentifier(xmlReportedTransaction.getTransactionIdentifier());
                xmlReportedTransaction.setTransactionIdentifier(this.generateRefundIdentifier(transactionId));
            } else if (xmlReportedTransaction.getTransactionIdentifier().equals(xmlReportedTransaction.getCorrTransactionIdentifier())) {
                xmlReportedTransaction.setTransactionIdentifier(this.generateRefundIdentifier(transactionId));
            }
        }
        this.parseDates(xmlReportedTransaction);
        xmlReportedTransaction.setAmount(this.parseAmount());
        this.parsePaymentMethod(xmlReportedTransaction);
        xmlReportedTransaction.setInitiatedPhysical(this.parseInitiatedPhysical());
        xmlReportedTransaction.setPayerMs(this.parsePayerMs());
        this.parsePspRole(xmlReportedTransaction);
        return xmlReportedTransaction;
    }

    private String generateRefundIdentifier(String transactionIdentifier) {
        Random random = new Random();
        String newIdentifier = "REF_" + random.nextInt(100000) + "_" + transactionIdentifier;
        return newIdentifier.substring(0, Math.min(newIdentifier.length(), 100));
    }

    private boolean parseIsRefund() throws XMLStreamException {
        Map<String, String> attributes = this.cesopXmlReader.getXmlStreamReaderWrapper().getAttributes();
        return ReportedTransactionXmlReader.parseBoolean(attributes.get("IsRefund"));
    }

    private String parseTransactionIdentifier() throws XMLStreamException {
        Map<String, String> valuesMap = this.cesopXmlReader.readNextTagIntoMap(ValidationConstants.XML.TRANSACTION_IDENTIFIER_QNAME);
        return valuesMap.get("/TransactionIdentifier");
    }

    private String parseCorrTransactionIdentifier() throws XMLStreamException {
        Optional<Map<String, String>> valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.CORR_TRANSACTION_IDENTIFIER_QNAME);
        return valuesMap.map(m -> (String)m.get("/CorrTransactionIdentifier")).orElse(null);
    }

    private void parseDates(XmlReportedTransaction xmlReportedTransaction) throws XMLStreamException {
        Optional<Map<String, String>> valuesMap;
        while ((valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.DATE_TIME_QNAME)).isPresent()) {
            String value = valuesMap.get().get("/DateTime");
            String type = valuesMap.get().get("/DateTime@transactionDateType");
            String other = valuesMap.get().get("/DateTime@transactionDateOther");
            TransactionDateEnum transactionDateEnum = TransactionDateEnum.findByLabel(type);
            try {
                ValidationErrorUtils.XML_DATE_TIME_FORMATTER.parse(value);
            }
            catch (DateTimeParseException e) {
                throw new CesopParsingException("Error while reading the XML file: " + e.getMessage(), e);
            }
            xmlReportedTransaction.addDate(transactionDateEnum, value, other);
        }
    }

    private XmlTypeAndValue parseAmount() throws XMLStreamException {
        Map<String, String> valuesMap = this.cesopXmlReader.readNextTagIntoMap(ValidationConstants.XML.AMOUNT_QNAME);
        String amount = valuesMap.get("/Amount");
        if (amount.split("\\.")[0].length() > 15) {
            throw new CesopParsingException(String.format("Error while reading the XML file: The amount %s is too large. Amounts must be less than 10^15.", amount));
        }
        return new XmlTypeAndValue(valuesMap.get("/Amount@currency"), amount);
    }

    private void parsePaymentMethod(XmlReportedTransaction xmlReportedTransaction) throws XMLStreamException {
        Optional<Map<String, String>> valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.PAYMENT_METHOD_QNAME);
        if (valuesMap.isPresent()) {
            String paymentMethodType = valuesMap.get().get("/PaymentMethod/PaymentMethodType");
            String paymentMethodOther = valuesMap.get().get("/PaymentMethod/PaymentMethodOther");
            xmlReportedTransaction.setPaymentMethodType(paymentMethodType);
            if (LangUtils.isNotBlank(paymentMethodOther)) {
                int index = this.otherPaymentMethods.indexOf(paymentMethodOther);
                if (index == -1) {
                    this.otherPaymentMethods.add(paymentMethodOther);
                    xmlReportedTransaction.setPaymentMethodOtherId(this.otherPaymentMethods.size());
                } else {
                    xmlReportedTransaction.setPaymentMethodOtherId(index + 1);
                }
            }
        } else {
            xmlReportedTransaction.setPaymentMethodType(PAYMENT_METHOD_NONE);
        }
    }

    private boolean parseInitiatedPhysical() throws XMLStreamException {
        Map<String, String> valuesMap = this.cesopXmlReader.readNextTagIntoMap(ValidationConstants.XML.INITIATED_PHYSICAL_QNAME);
        return ReportedTransactionXmlReader.parseBoolean(valuesMap.get("/InitiatedAtPhysicalPremisesOfMerchant"));
    }

    private XmlTypeAndValue parsePayerMs() throws XMLStreamException {
        Map<String, String> valuesMap = this.cesopXmlReader.readNextTagIntoMap(ValidationConstants.XML.PAYER_MS_QNAME);
        return new XmlTypeAndValue(ValidationErrorUtils.convertGreece(valuesMap.get("/PayerMS")), valuesMap.get("/PayerMS@PayerMSSource"));
    }

    private void parsePspRole(XmlReportedTransaction xmlReportedTransaction) throws XMLStreamException {
        Optional<Map<String, String>> valuesMap = this.cesopXmlReader.readNextTagIfEquals(ValidationConstants.XML.PSP_ROLE_QNAME);
        if (valuesMap.isPresent()) {
            String pspRoleType = valuesMap.get().get("/PSPRole/PSPRoleType");
            String pspRoleOther = valuesMap.get().get("/PSPRole/PSPRoleOther");
            xmlReportedTransaction.setPspRoleType(pspRoleType);
            if (LangUtils.isNotBlank(pspRoleOther)) {
                int index = this.otherPspRoles.indexOf(pspRoleOther);
                if (index == -1) {
                    this.otherPspRoles.add(pspRoleOther);
                    xmlReportedTransaction.setPspRoleOtherId(this.otherPspRoles.size());
                } else {
                    xmlReportedTransaction.setPspRoleOtherId(index + 1);
                }
            }
        }
    }
}

